/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public final class SerializerHarvestEntry
implements ISerializer<HarvestEntry> {
    public static ISerializer<HarvestEntry> SERIALIZER = new SerializerHarvestEntry();

    public HarvestEntry fromJSON(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            Float chance = (Float)Serializers.FLOAT.fromJSON(obj, "chance");
            ItemStack output = (ItemStack)Serializers.ITEM_STACK.fromJSON(obj, "output");
            int minRolls = (Integer)Serializers.INT.fromJSON(obj, "minRolls", (Object)1);
            int maxRolls = (Integer)Serializers.INT.fromJSON(obj, "maxRolls", (Object)1);
            return new HarvestEntry(chance.floatValue(), output, minRolls, maxRolls);
        }
        throw new JsonParseException("Expected harvest entry to be a JSON object.");
    }

    public JsonElement toJSON(HarvestEntry toWrite) {
        JsonObject json = new JsonObject();
        Serializers.FLOAT.toJSON(json, "chance", (Object)Float.valueOf(toWrite.getChance()));
        Serializers.ITEM_STACK.toJSON(json, "output", (Object)toWrite.getItem());
        Serializers.INT.toJSON(json, "minRolls", (Object)toWrite.getMinRolls());
        Serializers.INT.toJSON(json, "maxRolls", (Object)toWrite.getMaxRolls());
        return json;
    }

    public HarvestEntry fromByteBuf(FriendlyByteBuf buffer) {
        Float chance = (Float)Serializers.FLOAT.fromByteBuf(buffer);
        ItemStack output = (ItemStack)Serializers.ITEM_STACK.fromByteBuf(buffer);
        int minRolls = (Integer)Serializers.INT.fromByteBuf(buffer);
        int maxRolls = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new HarvestEntry(chance.floatValue(), output, minRolls, maxRolls);
    }

    public void toByteBuf(FriendlyByteBuf buffer, HarvestEntry toWrite) {
        Serializers.FLOAT.toByteBuf(buffer, (Object)Float.valueOf(toWrite.getChance()));
        Serializers.ITEM_STACK.toByteBuf(buffer, (Object)toWrite.getItem());
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.getMinRolls());
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.getMaxRolls());
    }

    public Tag toNBT(HarvestEntry toWrite) {
        CompoundTag nbt = new CompoundTag();
        Serializers.FLOAT.toNBT(nbt, "chance", (Object)Float.valueOf(toWrite.getChance()));
        Serializers.ITEM_STACK.toNBT(nbt, "output", (Object)toWrite.getItem());
        Serializers.INT.toNBT(nbt, "minRolls", (Object)toWrite.getMinRolls());
        Serializers.INT.toNBT(nbt, "maxRolls", (Object)toWrite.getMaxRolls());
        return nbt;
    }

    public HarvestEntry fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            Float chance = (Float)Serializers.FLOAT.fromNBT(tag, "chance");
            ItemStack output = (ItemStack)Serializers.ITEM_STACK.fromNBT(tag, "output");
            int minRolls = (Integer)Serializers.INT.fromNBT(tag, "minRolls");
            int maxRolls = (Integer)Serializers.INT.fromNBT(tag, "maxRolls");
            return new HarvestEntry(chance.floatValue(), output, minRolls, maxRolls);
        }
        throw new JsonParseException("Expected harvest entry to be a JSON object.");
    }
}

